/*****************************************************************************
*  LPC4357 SCT demo program
*
*  Use SCT timer capture and capture control features. It implements a
*  PWM decoder which measures the duty cycle of a PWM signal and determines
*  whether it is above (max_width) or below (min_width) a specific value.
*  The PWM signal frequency is assumed to be 10 kHz. Two output signals
*  (width_error and timeout) are included to indicate when the 10 kHz signal
*  has an error or is missing.
*  SCT_IN0 (pin P2_4)  = PWM signal input
*  SCT_OUT0 (pin P2_8) = timeout
*  SCT_OUT1 (pin P2_7) = width_error
*****************************************************************************/
#include "nxp_lpc43xx.h"
#include "mcb4300.h"

extern void SCT_Init(void);

void SCT_IRQHandler(void)
{
  uint32_t status = LPC_SCT->EVFLAG;

    if (status & 1)                                    // EVENT 0: timeout
    {
		/* New measurement result */
		;
    }

    if (status & (1 << 5))                             // EVENT 5: width error
    {
		/* Time-out (no signal) */
		;
    }
    LPC_SCT->EVFLAG = status;                          // Acknowledge interrupts
}

int main (void)
{
  volatile static int i = 0;                           // force counter to be placed into memory

    SystemCoreClockUpdate ();                          // Update system core clock

    LPC_CCU1->CLK_M4_SCT_CFG  = (1 << 0);              // enable SCT clock in CCU1 

    MCB4300_Init();                                    // Initialize MCB4300 board stuff
    SCT_Init();                                        // Initialize SCT1


    SCT_Init();                                        // Initialize SCT

    while (1)                                          // loop forever
    {
       	/* The settings are chosen in % of duty cycle (assuming a PWM frequency of 10 kHz).
       	 * (In a real world application you want to select better resolution!)
       	 */
        i = LPC_SCT->CAP[4].U;
    }
}
